########## Tenan et al. 
########## Product space method script
########## Example with prior set 4 in Table 2



##############################			
#
#	Log-Normal model
#
##############################


# read data
d <- read.csv("/path/to/file/data_pinna.csv", header=TRUE)


# dataset structure
str(d)
#'data.frame':	234 obs. of  3 variables:
# $ W   : num  9.3 15 8.1 17.4 13.4 13.1 12.3 12.8 8.2 12.2 ...
# $ CAPT: int  1 0 1 1 1 0 1 1 0 0 ...
# $ site: int  1 1 1 1 1 1 1 1 1 1 ...

# variables
# W = shell width (cm)
# CAPT = recaptured (1) or not (0)
# site = sampling site



library("R2jags")


sink("LogNorm.REanova.trick.txt")
cat("

data{
C <- 100
for (i in 1:n.ind) {
	zeros[i] <- 0
}
}

model {

# Priors 
for (i in 1:n.sites){
	alpha[i] ~ dnorm(mu.site, tau.site) 	# Prior for population means
	effe[i] <- alpha[i] - mu.site 	# Population effects as derived quantities
}
mu.site ~ dnorm(0, 0.001)			# Hyperprior for grand mean shell width 
tau.site <- 1 / (sigma.site * sigma.site)
sigma.site ~ dunif(0, 10)		# Hyperprior for sd of population effects

tau <- 1 / (sigma * sigma)
sigma ~ dunif(0, 10)		# Prior for residual sd


# Likelihood
for (i in 1:n.ind) {
	zeros[i] ~ dpois(zeros.mean[i])
	zeros.mean[i] <- -loglik[i] + C
	loglik[i] <- -0.5 * log(2 * 3.14159) -log(width[i]) - 0.5 * log(sigma * sigma) - 0.5 * pow((log(width[i])-mu[i]), 2) / (sigma * sigma)
	mu[i] <- alpha[site[i]]
}
 
}
",fill=TRUE)
sink()

# Bundle data
bugs.data <- list(width = d$W, site = d$site, n.sites = length(unique(d$site)), n.ind = dim(d)[1])

# Inits function
inits <- function(){ list(mu.site = runif(1, 0, 100), sigma.site = rlnorm(1), sigma = rlnorm(1) )}

# Params to estimate
params <- c("mu.site", "alpha", "effe", "sigma.site", "sigma")

# MCMC settings
ni <- 30000
nt <- 5
nb <- 15000
nc <- 3

# Call JAGS
out <- jags(bugs.data, inits, params, "LogNorm.REanova.trick.txt", n.chains = nc, n.thin = nt, n.iter = ni, n.burnin = nb, working.directory = getwd())


######### pseudopriors
LN.mu.site.mu.ps <- mean(out$BUGSoutput$sims.list$mu.site)
mu.site.sigma.ps <- sd(out$BUGSoutput$sims.list$mu.site)
LN.mu.site.tau.ps <- 1/(mu.site.sigma.ps * mu.site.sigma.ps)
LN.sigma.site.min.ps <- min(out$BUGSoutput$sims.list$sigma.site)
LN.sigma.site.max.ps <- max(out$BUGSoutput$sims.list$sigma.site)
LN.sigma.min.ps <- min(out$BUGSoutput$sims.list$sigma)
LN.sigma.max.ps <- max(out$BUGSoutput$sims.list$sigma)

# save pseudopriors
save(LN.mu.site.mu.ps, LN.mu.site.tau.ps, LN.sigma.site.min.ps, LN.sigma.site.max.ps, LN.sigma.min.ps, LN.sigma.max.ps, file="/path/to/file/Pseudo_LogNorm_REanova.trick.Rdata", ascii=TRUE )




##############################			
#
#	Gamma model
#
##############################



sink("Gamma.REanova.trick.txt")
cat("

data{
C <- 100
for (i in 1:n.ind) {
	zeros[i] <- 0
}
}

model {

# Priors 
for (i in 1:n.sites){
	alpha[i] ~ dnorm(mu.site, tau.site) 	# Prior for population means
	effe[i] <- alpha[i] - mu.site 	# Population effects as derived quantities
}
mu.site ~ dnorm(0, 0.001)			# Hyperprior for grand mean shell width 
tau.site <- 1 / (sigma.site * sigma.site)
sigma.site ~ dunif(0, 10)		# Hyperprior for sd of population effects

tau <- 1 / (sigma * sigma)
sigma ~ dunif(0, 10)		# Prior for residual sd

# Likelihood
for (i in 1:n.ind) {
	zeros[i] ~ dpois(zeros.mean[i])
	zeros.mean[i] <- -loglik[i] + C
	loglik[i] <- (mu[i]*tau) * log(tau) + ((mu[i]*tau)-1) * log(width[i]) - tau * width[i] - loggam((mu[i]*tau))
	log(mu[i]) <- alpha[site[i]]
}

}
",fill=TRUE)
sink()

# Bundle data
bugs.data <- list(width = d$W, site = d$site, n.sites = length(unique(d$site)), n.ind = dim(d)[1])

# Inits function
inits <- function(){ list(mu.site = runif(1, 0, 100), sigma.site = rlnorm(1), sigma = rlnorm(1) )}

# Params to estimate
params <- c("mu.site", "alpha", "effe", "sigma.site", "sigma")

# MCMC settings
ni <- 30000
nt <- 5
nb <- 15000
nc <- 3

# Call JAGS
out <- jags(bugs.data, inits, params, "Gamma.REanova.trick.txt", n.chains = nc, n.thin = nt, n.iter = ni, n.burnin = nb, working.directory = getwd())


######### pseudopriors
G.mu.site.mu.ps <- mean(out$BUGSoutput$sims.list$mu.site)
mu.site.sigma.ps <- sd(out$BUGSoutput$sims.list$mu.site)
G.mu.site.tau.ps <- 1/(mu.site.sigma.ps * mu.site.sigma.ps)
G.sigma.site.min.ps <- min(out$BUGSoutput$sims.list$sigma.site)
G.sigma.site.max.ps <- max(out$BUGSoutput$sims.list$sigma.site)
G.sigma.min.ps <- min(out$BUGSoutput$sims.list$sigma)
G.sigma.max.ps <- max(out$BUGSoutput$sims.list$sigma)


save(G.mu.site.mu.ps, G.mu.site.tau.ps, G.sigma.site.min.ps, G.sigma.site.max.ps, G.sigma.min.ps, G.sigma.max.ps, file="/path/to/file/Pseudo_Gamma_REanova.trick.Rdata", ascii=TRUE )





##############################
#
#	Product space method
#
##############################


# read data
d <- read.csv("/path/to/file/data_pinna.csv", header=TRUE)


library("R2jags")

# model
sink("MS_LNvsGA_PRIOR1.txt")
cat("

data{
C <- 100
for (i in 1:n.ind) {
	zeros[i] <- 0
}
}

model {

######### MODEL INDEX
M ~ dcat(p[])
p[1] <- prior1
p[2] <- 1-prior1
postr1 <- 2-M
postr2 <- M-1


######### PRIORS and PSEUDOPRIORS

# sigma of LogNormal model 
sigmaLN ~ dunif(PROP.MIN.sigmaLN, PROP.MAX.sigmaLN)
PROP.MIN.sigmaLN <- (M-1) * LN.sigma.min.ps
PROP.MAX.sigmaLN <- (2-M) * 10 + (M-1) * LN.sigma.max.ps	

# sigma of Gamma model 
tauG <- 1 / (sigmaG * sigmaG)
sigmaG ~ dunif(PROP.MIN.sigmaG, PROP.MAX.sigmaG)
PROP.MIN.sigmaG <- (2-M) * G.sigma.min.ps
PROP.MAX.sigmaG <- (M-1) * 10 + (2-M) * G.sigma.max.ps	

# alpha of both models...
for (j in 1:n.sites){
	alphaLN[j] ~ dnorm(mu.siteLN, tau.siteLN)
	alphaG[j] ~ dnorm(mu.siteG, tau.siteG)
}

# ... LogNormal model
mu.siteLN ~ dnorm(PROP.MU.mu.siteLN, PROP.TAU.mu.siteLN)
PROP.MU.mu.siteLN <- (M-1) * LN.mu.site.mu.ps
PROP.TAU.mu.siteLN <- (2-M) * 0.001 + (M-1) * LN.mu.site.tau.ps

tau.siteLN <- 1 / (sigma.siteLN * sigma.siteLN)

sigma.siteLN ~ dunif(PROP.MIN.sigma.siteLN, PROP.MAX.sigma.siteLN) 
PROP.MIN.sigma.siteLN <- (M-1) * LN.sigma.site.min.ps
PROP.MAX.sigma.siteLN <- (2-M) * 10 + (M-1) * LN.sigma.site.max.ps
	
# ... Gamma model
mu.siteG ~ dnorm(PROP.MU.mu.siteG, PROP.TAU.mu.siteG)
PROP.MU.mu.siteG <- (2-M) * G.mu.site.mu.ps
PROP.TAU.mu.siteG <- (M-1) * 0.001 + (2-M) * G.mu.site.tau.ps

tau.siteG <- 1 / (sigma.siteG * sigma.siteG)

sigma.siteG ~ dunif(PROP.MIN.sigma.siteG, PROP.MAX.sigma.siteG) 
PROP.MIN.sigma.siteG <- (2-M) * G.sigma.site.min.ps
PROP.MAX.sigma.siteG <- (M-1) * 10 + (2-M) * G.sigma.site.max.ps


# Likelihood
for (i in 1:n.ind) {
	zeros[i] ~ dpois(zeros.mean[i])
	zeros.mean[i] <- -loglik[M,i] + C
		
	# LogNormal model
	loglik[1,i] <- loglik1[i]
	loglik1[i] <- -0.5 * log(2 * 3.14159) -log(width[i]) - 0.5 * log(sigmaLN * sigmaLN) - 0.5 * pow((log(width[i])-mu[i]), 2) / (sigmaLN * sigmaLN)
#	mu[i] <- alphaN[site[i]]
	
	# Gamma model
	loglik[2,i] <- loglik2[i]
	loglik2[i] <- (mu[i]*tauG) * log(tauG) + ((mu[i]*tauG)-1) * log(width[i]) - tauG * width[i] - loggam((mu[i]*tauG))
#	log(mu[i]) <- alphaG[site[i]]
	
	mu[i] <- (2-M) * alphaLN[site[i]] + (M-1) * exp(alphaG[site[i]])		
}
 
}
",fill=TRUE)
sink()

# load pseudopriors
load("/path/to/file/Pseudo_LogNorm_REanova.trick.Rdata")
load("/path/to/file/Pseudo_Gamma_REanova.trick.Rdata")

# Bundle data
bugs.data <- list(width = d$W, site = d$site, n.sites = length(unique(d$site)), n.ind = dim(d)[1],
                  LN.sigma.min.ps = LN.sigma.min.ps, LN.sigma.max.ps = LN.sigma.max.ps,
                  LN.mu.site.mu.ps = LN.mu.site.mu.ps, LN.mu.site.tau.ps = LN.mu.site.tau.ps,
                  LN.sigma.site.min.ps = LN.sigma.site.min.ps, LN.sigma.site.max.ps = LN.sigma.site.max.ps,
                  G.sigma.min.ps = G.sigma.min.ps, G.sigma.max.ps = G.sigma.max.ps,
                  G.mu.site.mu.ps = G.mu.site.mu.ps, G.mu.site.tau.ps = G.mu.site.tau.ps,
                  G.sigma.site.min.ps = G.sigma.site.min.ps, G.sigma.site.max.ps = G.sigma.site.max.ps,
                  prior1 = 0.9999999999999
                  )

# Inits function
inits <- function(){ list(M = sample(c(1,2), 1), sigmaLN = runif(1, LN.sigma.min.ps, LN.sigma.max.ps), 
                          sigmaG = runif(1, G.sigma.min.ps, G.sigma.max.ps),
                          mu.siteLN = rnorm(1, LN.mu.site.mu.ps, 1/sqrt(LN.mu.site.tau.ps)), 
                          sigma.siteLN = runif(1, LN.sigma.site.min.ps, LN.sigma.site.max.ps),
                          mu.siteG = rnorm(1, G.mu.site.mu.ps, 1/sqrt(G.mu.site.tau.ps)), 
                          sigma.siteG = runif(1, G.sigma.site.min.ps, G.sigma.site.max.ps)  
                          )}


# Params to estimate
params <- c("postr1", "postr2")

# MCMC settings
ni <- 1001000
nt <- 3
nb <- 1000
nc <- 3


# Call JAGS
out <- jags(bugs.data, inits, params, "MS_LNvsGA_PRIOR1.txt", n.chains = nc, n.thin = nt, n.iter = ni, n.burnin = nb, working.directory = getwd())



# Visualize prior and posterior model probabilities
Mpost <- out$BUGSoutput$sims.array[,,"postr1"] # JAGS
M <- 2-Mpost
prob <- matrix(,2,5,dimnames=list(c("M1","M2"),c("pr","ps1","ps2","ps3","psc")));
prior <- c(bugs.data$prior1, 1-bugs.data$prior1)
prob[,1] <- prior

nchains <- 3
for(m in 1:2){
for(ch in 1:nchains){
	prob[m,ch+1]=mean(M[,ch]==m)
	}
}
  
postr <- rowMeans(prob[,2:4])
prob[,5] <- (postr/prior)/sum(postr/prior)
  
prob


# Log Bayes factors(12) with product space method
postr <- prob[,5]
logb <- log(postr[1])-log(postr[2])

logb


